<?php
session_start();

$password_file = __DIR__ . '/admin_password.txt';
$admin_password = file_exists($password_file) ? trim(file_get_contents($password_file)) : 'admin123';

if (!isset($_SESSION['logged_in'])) {
    if (isset($_POST['password']) && $_POST['password'] === $admin_password) {
        $_SESSION['logged_in'] = true;
        header("Location: manage_descriptions.php");
        exit;
    } else {
        echo '<form method="POST"><h3>تسجيل الدخول:</h3>
              <input type="password" name="password" placeholder="كلمة المرور">
              <button type="submit">دخول</button></form>';
        exit;
    }
}

$host = "localhost";
$user = "blenco1_billing_system";
$password = "Hafshan@2552";
$dbname = "blenco1_billing_system";
$conn = new mysqli($host, $user, $password, $dbname);
if ($conn->connect_error) {
    die("فشل الاتصال: " . $conn->connect_error);
}

// حذف وصف
if (isset($_GET['delete'])) {
    $id = intval($_GET['delete']);
    $conn->query("DELETE FROM descriptions WHERE id = $id");
    header("Location: manage_descriptions.php");
    exit;
}

// تعديل وصف
if (isset($_POST['update'])) {
    $id = intval($_POST['id']);
    $label = $_POST['label'];
    $price = floatval($_POST['unit_price']);
    $stmt = $conn->prepare("UPDATE descriptions SET label = ?, unit_price = ? WHERE id = ?");
    $stmt->bind_param("sdi", $label, $price, $id);
    $stmt->execute();
    header("Location: manage_descriptions.php");
    exit;
}

// إضافة وصف جديد
if (isset($_POST['add'])) {
    $label = $_POST['new_label'];
    $price = floatval($_POST['new_price']);
    $stmt = $conn->prepare("INSERT INTO descriptions (label, unit_price) VALUES (?, ?)");
    $stmt->bind_param("sd", $label, $price);
    $stmt->execute();
    header("Location: manage_descriptions.php");
    exit;
}

// تغيير كلمة المرور
if (isset($_POST['change_password'])) {
    $new_pass = $_POST['new_password'];
    file_put_contents($password_file, $new_pass);
    echo "<script>alert('تم تحديث كلمة المرور بنجاح');</script>";
}

$search = isset($_GET['search']) ? $_GET['search'] : '';
$stmt = $conn->prepare("SELECT * FROM descriptions WHERE label LIKE ? ORDER BY id DESC");
$like = "%$search%";
$stmt->bind_param("s", $like);
$stmt->execute();
$result = $stmt->get_result();
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="UTF-8">
  <title>إدارة الأوصاف</title>
  <style>
    body { font-family: Tahoma, sans-serif; background-color: #f9f9f9; text-align: center; }
    h2, h3 { margin: 20px 0; }
    form { margin: 10px auto; max-width: 600px; font-size: 18px; }
    input, button, select { font-size: 18px; padding: 8px; margin: 5px; width: 90%; }
    table { margin: 20px auto; border-collapse: collapse; width: 90%; font-size: 18px; background: #fff; }
    th, td { padding: 10px; border: 1px solid #ccc; }
    th { background-color: #e9e9e9; }
    button { background-color: #007bff; color: white; border: none; border-radius: 5px; cursor: pointer; }
    button:hover { background-color: #0056b3; }
    a { text-decoration: none; color: red; }
  </style>
</head>
<html lang="ar" dir="rtl">
<head>
  <meta charset="UTF-8">
  <title>إدارة الأوصاف</title>
</head>
<body>
  <h2>إدارة أوصاف الفاتورة</h2>

  <form method="GET">
    <input type="text" name="search" placeholder="ابحث عن وصف..." value="<?= htmlspecialchars($search) ?>">
    <button type="submit">بحث</button>
  </form>

  <h3>إضافة وصف جديد</h3>
  <form method="POST">
    <input type="text" name="new_label" placeholder="الوصف" required>
    <input type="number" step="0.01" name="new_price" placeholder="السعر" required>
    <button type="submit" name="add">إضافة</button>
  </form>

  <h3>تعديل كلمة المرور</h3>
  <form method="POST">
    <input type="password" name="new_password" placeholder="كلمة مرور جديدة" required>
    <button type="submit" name="change_password">تحديث كلمة المرور</button>
  </form>

  <table border="1" cellpadding="8" style="margin-top: 20px;">
    <tr>
      <th>رقم</th>
      <th>الوصف</th>
      <th>سعر الوحدة</th>
      <th>تعديل</th>
      <th>حذف</th>
    </tr>
    <?php while ($row = $result->fetch_assoc()): ?>
    <tr>
      <form method="POST">
        <td><?= $row['id'] ?></td>
        <td><input type="text" name="label" value="<?= htmlspecialchars($row['label']) ?>" required></td>
        <td><input type="number" step="0.01" name="unit_price" value="<?= $row['unit_price'] ?>" required></td>
        <td>
          <input type="hidden" name="id" value="<?= $row['id'] ?>">
          <button type="submit" name="update">تحديث</button>
        </td>
        <td><a href="?delete=<?= $row['id'] ?>" onclick="return confirm('هل أنت متأكد من الحذف؟');">🗑️ حذف</a></td>
      </form>
    </tr>
    <?php endwhile; ?>
  </table>
</body>
</html>